/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.api.tinkering;

import com.blakebr0.mysticalagriculture.api.lib.AbilityCache;
import com.blakebr0.mysticalagriculture.api.tinkering.AugmentAttributeModifier;
import com.blakebr0.mysticalagriculture.api.tinkering.AugmentType;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.registries.DeferredHolder;

public class Augment {
    private final ResourceLocation id;
    private final DeferredHolder<Item, Item> item;
    private int tier;
    private EnumSet<AugmentType> types;
    private int primaryColor;
    private int secondaryColor;
    private boolean enabled;

    public Augment(ResourceLocation id, int tier, EnumSet<AugmentType> types, int primaryColor, int secondaryColor) {
        this.id = id;
        this.item = DeferredHolder.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mysticalagriculture", (String)(id.getPath() + "_augment")));
        this.tier = tier;
        this.types = types;
        this.primaryColor = FastColor.ARGB32.color((int)255, (int)primaryColor);
        this.secondaryColor = FastColor.ARGB32.color((int)255, (int)secondaryColor);
        this.enabled = true;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public String getName() {
        return this.getId().getPath();
    }

    public String getModId() {
        return this.getId().getNamespace();
    }

    public String getNameWithSuffix(String suffix) {
        return String.format("%s_%s", this.getName(), suffix);
    }

    public MutableComponent getDisplayName() {
        return Component.translatable((String)String.format("augment.%s.%s", this.getModId(), this.getName()));
    }

    public MutableComponent getDescriptionDisplayText() {
        return Component.translatable((String)String.format("augment.%s.%s.description", this.getModId(), this.getName())).withStyle(ChatFormatting.GRAY);
    }

    public EnumSet<AugmentType> getAugmentTypes() {
        return this.types;
    }

    public int getTier() {
        return this.tier;
    }

    public Item getItem() {
        return (Item)this.item.get();
    }

    public int getPrimaryColor() {
        return this.primaryColor;
    }

    public Augment setPrimaryColor(int color) {
        this.primaryColor = color;
        return this;
    }

    public int getSecondaryColor() {
        return this.secondaryColor;
    }

    public Augment setSecondaryColor(int color) {
        this.secondaryColor = color;
        return this;
    }

    public boolean hasEffect() {
        return this.getTier() >= 5;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Augment setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public boolean onItemUse(UseOnContext context) {
        return false;
    }

    public boolean onRightClick(ItemStack stack, Level level, Player player, InteractionHand hand) {
        return false;
    }

    public boolean onRightClickEntity(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        return false;
    }

    public boolean onHitEntity(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        return false;
    }

    public boolean onBlockDestroyed(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity entity) {
        return false;
    }

    public void onInventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean isSelected) {
    }

    public void onArmorTick(ItemStack stack, Level level, Player player) {
    }

    public void onPlayerTick(Level level, Player player, AbilityCache cache) {
    }

    public void onPlayerFall(Level level, Player player, LivingFallEvent event) {
    }

    public List<AugmentAttributeModifier> getAttributeModifiers() {
        return List.of();
    }

    public boolean hasSetBonus() {
        return false;
    }

    public MutableComponent getSetBonusDisplayText() {
        return Component.translatable((String)String.format("augment.%s.%s.set_bonus", this.getModId(), this.getName())).withStyle(ChatFormatting.GRAY);
    }
}

